#ifndef _WORKER_IMPL_HPP
#define _WORKER_IMPL_HPP 1

#include <mutex>
#include <glpk.h>
#include <chrono>
#include <string>
#include <vector>
#include "thrift/gen-cpp/Remote.h"

class Worker_impl : virtual public RemoteIf {
private:
	static glp_prob * _lp;
	static int _megaMemLimit; // fuer logging
	glp_smcp _parm1;
	glp_iocp _parm2;
	static int TIMEOUT_REACHED;

	static Configurator _conf;
	static int _jobLimit;
	static std::chrono::steady_clock::time_point _startPoint;

	// callback function to the glpk mip !!
	friend void influence(glp_tree * tr, void * info);

public:
	Worker_impl(const int & megaMemLimit);

	static Obj _data;
	static std::mutex _mu;
	static Job _bestJob;
	static double _bestBound; // only changed by influence
	static bool _kill;
	static bool _silent;

	void  input(const Obj & data, const Configurator & conf);
	void   kill();
	void  solve(SolveResult & _sreturn, const Job & bestJob, const Job & newJob);
	void update(UpdateResult & _return, const Job & bestJob);
};

#endif
